<?PHP  if ( ! defined('BASEPATH')) exit('No direct script access allowed'); 

class Permissions {
	private $CI;
	public function __construct() {
		$this->CI =& get_instance();
		$this->CI->load->model('usersmodel');
		$this->CI->load->model('applicationmodel');
	}
	
	/*
	 * This function will return an array of uids who are DaaS administrators
	 */
	public function get_daas_admins(){
		$admins = $this->CI->usersmodel->get_daas_admins();
		return $admins;
	}
	
	/*
	 * This function returns comma separated string of application IDs that the user has access to
	 */
	public function get_application_admin_permission($id){
		$permissions = $this->CI->usersmodel->get_user_permissions_from_org_id($id);
		
		$app_list = $permissions['Application'];
		$apps = array_filter($app_list, array($this, "search_arr"));
		$keys = array_keys($apps);		

		return $keys;
	}
	
	/* This function uses organizational id (for DOD this is EDIPI) to pull the user permissions,
	 * which return as an associative array split between 'API' and 'Application' permissions.
	 */
	public function get_user_permissions($id) {
		//use this line for local development and debugging only
		//$permissions = array('API' => array('admins'=>TRUE), 'Registered' => true);
		
		//use this line for actual development
		$permissions = $this->CI->usersmodel->get_user_permissions_from_org_id($id);
		return $permissions;
	}
	
	/* This function uses the permissions returned from get_user_permissions to set an associative array
	 * of the tabs that the user should be able to see for use in loading views.
	 */
	public function set_tab_access_from_permissions($permissions) {
		//least amount of permissions
		$show = array('onboarding'=>true,'applications'=>false,'reports'=>false,'administration'=>false);
		//if registered allow applications tab
		if(isset($permissions['Registered']) && $permissions['Registered']) {
			$show = array('onboarding'=>true,'applications'=>true,'reports'=>false,'administration'=>false);
		}
		//TO-DO: for FOC, if application admin, allow administration tab
		if(isset($permissions['Application'])) {
			foreach($permissions['Application'] as $key => $value) {
				$application = $this->CI->applicationmodel->get_application($key);
				if($application->num_rows() === 1 && isset($value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) && $value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) {
					$show = array('onboarding'=>true,'applications'=>true,'reports'=>false,'administration'=>false);
				}
			}
		}
		//api admins get all tabs
		if(isset($permissions['API']) && $permissions['API']['admins']) {
			$show = array('onboarding'=>true,'applications'=>true,'reports'=>true,'administration'=>true);
		}
		return $show;
	}
	
	/* This function uses the permissions returned from get_user_permissions to set an associative array
	 * of the admin views that the user should be able to see.
	 */
	public function set_admin_access_from_permissions($permissions) {
		//least amount of permissions
		$show = array('application_requests'=>false,'account_requests'=>false,'manage_accounts'=>false);
		//if application admin, allow manage users
		//TO-DO: For FOC, allow app admins to manage users for their app only
		if(isset($permissions['Application'])) {
			foreach($permissions['Application'] as $key => $value) {
				$application = $this->CI->applicationmodel->get_application($key);
				if($application->num_rows() === 1 && isset($value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) && $value[LDAP_APPLICATION_ADMIN_GROUP_NAME]) {
					$show = array('application_requests'=>false,'account_requests'=>false,'manage_accounts'=>false,'manage_groups'=>false);
				}
			}
		}
		//api admins get all functions
		if(isset($permissions['API']) && $permissions['API']['admins']) {
			$show = array('application_requests'=>true,'account_requests'=>true,'manage_accounts'=>true,'manage_groups'=>true);
		}
		return $show;
	}
	
	/* This function returns the authorized API controllers for a given application (given by application id)
	 * by looking up the permissions in LDAP and returning an associative array of permissions.
	 */
	public function get_api_authorization($app_id) {
		$this->CI->load->model('applicationmodel');
		$return_arr['direct'] = $this->CI->applicationmodel->get_direct_api_authorization($app_id);
		$return_arr['admin'] = $this->CI->applicationmodel->get_admin_api_authorization($app_id);
		return $return_arr;
	}
	
	/* This function gets the permissions a user has given a specific application
	 * and returns them as an associative array. Currently the only permission is send
	 * and that permissions is automatically given if the user is linked to the app, but
	 * this function could be expanded in the future to allow for expanded control of permissions.
	 */
	public function get_user_permissions_for_app($user_id,$app_id) {
		$this->CI->load->model('usersmodel');
		//set least possible permissions as default
		$permissions = array('send'=>FALSE); 
		$org_id = $this->CI->usersmodel->get_org_id_from_user_id($user_id);
		if($org_id !== FALSE) {
			if($this->CI->usersmodel->org_id_linked($org_id,$app_id) === TRUE) { $permissions['send'] = TRUE; }
		}
		return $permissions;
	}
	
	/* This function looks up the permissions a user has given an app, but uses their Direct address
	 * for the lookup.
	 */
	public function get_user_permissions_for_address($address,$app_id) {
		$this->CI->load->model('usersmodel');
		$this->CI->load->model('groupsmodel');
		$id = $this->CI->usersmodel->get_id_from_direct_address($address);
		if($id !== FALSE) {
			return $this->get_user_permissions_for_app($id,$app_id);
		}
		else{
			
			$app_dn=$this->CI->applicationmodel->get_dn_from_app_id($app_id);
			return $this->CI->groupsmodel->get_group_address_permissions_for_app_dn($address,$app_dn);
		}
		return FALSE;
	}
	
	/*
	 * This function will return true if the passed in array contains the 'admins' key
	 */
	private function search_arr($var) {
		return isset($var['admins']) && $var['admins'];
	}
}